/*------------------------------------------------------------------------------*
 *	File Name: 	OMLink.h								 						*
 *	Purpose:	MathLink wrap for OC										   	*
 *  Creation:																	* 
 *  	Copyright Originlab Corp. 2003, 2004, 2005								*
 *																				*
 *	Modification log	                                                        *
 *	EJP 2007-09-28 v8.0712 QA70-10448 FIX_WRITING_PASS_BUFFER_END				*
 *------------------------------------------------------------------------------*/      

#ifndef _OMLINK_H
#define _OMLINK_H


#ifdef __AFX_H__
	#ifdef OCMMLINK_EXPORTS
		#define OMLINK_API __declspec(dllexport)
	#else
		#define OMLINK_API __declspec(dllimport)
	#endif
	#define _L(_STR) _STR
	extern "C" {
#else
	#define OMLINK_API
	#pragma dll(OCMmLink)	// Associate all functions below to OCMmLink.dll which must be in the Origin EXE folder
#endif	//__AFX_H__

#define OCML_INPUT_BUF		2048
/// EJP 2007-09-28 v8.0712 QA70-10448 FIX_WRITING_PASS_BUFFER_END
///#define OCML_OUTPUT_BUF		2048
#define OCML_OUTPUT_BUF		8192 // 2K was too small for the output.
/// end FIX_WRITING_PASS_BUFFER_END
#define ARGS_NUMBER			5
#define ARGV_SIZE			ARGS_NUMBER + 1
#define DEFAULT_NAME		"MathKernel.exe"
#define DEFAULT_PROTOCOL	""
#define DEFAULT_MODE		"Launch"

#define	LINK_NAME			"-linkname"
#define	LINK_PROTOCOL		"-linkprotocol"
#define	LINK_MODE			"-linkmode"
#define	LINK_MATHLINK		"-mathlink"
#define LINK_OPTION			"-LinkOptions"

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// OMLINK constants need localization
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
#define OMLINK_DIALOG_CAPTION							_L("Origin Link for Mathematica")
#define OMLINK_UNSUPPORTED_PACKET						_L("Unsupported packet received (head = %d)\r\n")

#define OMLINK_ERRMSGBOX_CAPTION						_L("Error")
#define OMLINK_ERR_DATASET_INVALID						_L("Dataset invalid")
#define OMLINK_ERR_DATASET_COL_INVALID					_L("Dataset column invalid")
#define OMLINK_ERR_DATASET_ROW_INVALID					_L("Dataset row invalid")
#define OMLINK_ERR_LINK_NOT_OPEN						_L("Mathematica link not open")
#define OMLINK_ERR_SENDARRAY_FAILED						_L("Send array to Mathematica failed")
#define OMLINK_ERR_MATH_VAR_MISSING						_L("Mathematica variable missing")
#define OMLINK_ERR_RECVARRAY_FAILED						_L("Receive array from Mathematica failed")
#define OMLINK_ERR_DATASET_EMPTY						_L("Dataset is empty")
#define OMLINK_ERR_MATRIX_INVALID						_L("Matrix invalid")
#define OMLINK_ERR_MATRIX_COL_INVALID					_L("Matrix column invalid")
#define OMLINK_ERR_MATRIX_ROW_INVALID					_L("Matrix row invalid")
#define OMLINK_ERR_MEMORY_ALLOCATION_FAILED				_L("Memory allocation failed")
#define OMLINK_ERR_SENDMATRIX_FAILED					_L("Send matrix to Mathematica failed")
#define OMLINK_ERR_RECVMATRIX_FAILED					_L("Receive matrix from Mathematica failed")
#define OMLINK_ERR_FIRST_ROW_GREATER_THAN_LAST_ROW		_L("First row greater than last row")
#define OMLINK_ERR_DATASET_ROW_OUT_OF_RANGE				_L("Dataset row is out of range")
#define OMLINK_ERR_EVALUATE								_L("Evaluate error: Interacting with Mathematica")

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// Some constants have to duplicate at here so they can be used in OC
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
#ifndef _MATHLINK_H
#define _MATHLINK_H

#define ILLEGALPKT      0

#define CALLPKT         7
#define EVALUATEPKT    13
#define RETURNPKT       3

#define INPUTNAMEPKT    8
#define ENTERTEXTPKT   14
#define ENTEREXPRPKT   15
#define OUTPUTNAMEPKT   9
#define RETURNTEXTPKT   4
#define RETURNEXPRPKT  16

#define DISPLAYPKT     11
#define DISPLAYENDPKT  12

#define MESSAGEPKT      5
#define TEXTPKT         2

#define INPUTPKT        1
#define INPUTSTRPKT    21
#define MENUPKT         6
#define SYNTAXPKT      10

#define SUSPENDPKT     17
#define RESUMEPKT      18

#define BEGINDLGPKT    19
#define ENDDLGPKT      20

#define FIRSTUSERPKT  128
#define LASTUSERPKT   255


#define MLEUNKNOWN       -1
#define MLEOK             0
#define MLEDEAD           1
#define MLEGBAD           2
#define MLEGSEQ           3
#define MLEPBTK           4
#define MLEPSEQ           5
#define MLEPBIG           6
#define MLEOVFL           7
#define MLEMEM            8
#define MLEACCEPT         9
#define MLECONNECT       10
#define MLECLOSED        11
#define MLEDEPTH         12  /* internal error */
#define MLENODUPFCN      13  /* stream cannot be duplicated */

#define MLENOACK         15  /* */
#define MLENODATA        16  /* */
#define MLENOTDELIVERED  17  /* */
#define MLENOMSG         18  /* */
#define MLEFAILED        19  /* */

#define MLEPUTENDPACKET  21 /* unexpected call of MLEndPacket */
                            /* currently atoms aren't
                             * counted on the way out so this error is raised only when
                             * MLEndPacket is called in the midst of an atom
                             */
#define MLENEXTPACKET    22
#define MLEUNKNOWNPACKET 23
#define MLEGETENDPACKET  24
#define MLEABORT         25
#define MLEMORE          26 /* internal error */
#define MLENEWLIB        27
#define MLEOLDLIB        28
#define MLEBADPARAM      29


#define MLEINIT          32  /* the MathLink environment was not initialized */
#define MLEARGV          33  /* insufficient arguments to open the link */
#define MLEPROTOCOL      34  /* protocol unavailable */
#define MLEMODE          35  /* mode unavailable */
#define MLELAUNCH        36  /* launch unsupported */
#define MLELAUNCHAGAIN   37  /* cannot launch the program again from the same file */
#define MLELAUNCHSPACE   38  /* insufficient space to launch the program */
#define MLENOPARENT      39  /* found no parent to connect to */
#define MLENAMETAKEN     40  /* the linkname was already in use */
#define MLENOLISTEN      41  /* the linkname was not found to be listening */
#define MLEBADNAME       42  /* the linkname was missing or not in the proper form */
#define MLEBADHOST       43  /* the location was unreachable or not in the proper form */
#define MLERESOURCE      44  /* a required resource was missing */

#define MLELAST MLERESOURCE  /* for internal use only */

#define MLETRACEON      996  /* */
#define MLETRACEOFF     997  /* */
#define MLEDEBUG        998  /* */
#define MLEASSERT       999  /* an internal assertion failed */
#define MLEUSER        1000  /* start of user defined errors */

enum {	MLTerminateMessage = 1, MLInterruptMessage, MLAbortMessage,
	MLEndPacketMessage, MLSynchronizeMessage, MLImDyingMessage,
	MLWaitingAcknowledgment, MLMarkTopLevelMessage,
	MLFirstUserMessage = 128, MLLastUserMessage = 255 };


#define	MLTKOLDINT     'I'		/* 73 Ox49 01001001 */ /* integer leaf node */
#define	MLTKOLDREAL    'R'		/* 82 Ox52 01010010 */ /* real leaf node */


#define	MLTKFUNC    'F'		/* 70 Ox46 01000110 */ /* non-leaf node */

#define	MLTKERROR   (0)		/* bad token */
#define	MLTKERR     (0)		/* bad token */

/* text token bit patterns: 0010x01x --exactly 2 bits worth chosen to make things somewhat readable */
#define MLTK__IS_TEXT( tok) ( (tok & 0x00F6) == 0x0022)

/* begin filter */
/* ' '   00100000 */
/* '!'   00100001 */
/* end filter */
#define	MLTKSTR     '"'  /* 00100010 */
#define	MLTKSYM     '\043'  /* 00100011 */ /* octal here as hash requires a trigraph */

#define	MLTKREAL    '*'  /* 00101010 */
#define	MLTKINT     '+'  /* 00101011 */


/* The following defines are for internal use only */
#define	MLTKPCTEND  ']'     /* at end of top level expression */
#define	MLTKAPCTEND '\n'    /* at end of top level expression */
#define	MLTKEND     '\n'
#define	MLTKAEND    '\r'
#define	MLTKSEND    ','

#define	MLTKCONT    '\\'
#define	MLTKELEN    ' '

#define	MLTKNULL    '.'
#define	MLTKOLDSYM  'Y'     /* 89 0x59 01011001 */
#define	MLTKOLDSTR  'S'     /* 83 0x53 01010011 */


typedef unsigned long decoder_mask;
#define	MLTKPACKED	'P'     /* 80 0x50 01010000 */
#define	MLTKARRAY	'A'     /* 65 0x41 01000001 */
#define	MLTKDIM		'D'     /* 68 0x44 01000100 */

#define MLLENGTH_DECODER        ((decoder_mask) 1<<16)
#define MLTKPACKED_DECODER      ((decoder_mask) 1<<17)
#define MLTKARRAY_DECODER	    ((decoder_mask) 1<<18)
#define MLTKMODERNCHARS_DECODER ((decoder_mask) 1<<19)
#define MLTKALL_DECODERS (MLLENGTH_DECODER | MLTKPACKED_DECODER | MLTKARRAY_DECODER | MLTKMODERNCHARS_DECODER)

#define MLTK_FIRSTUSER '\x30'
#define MLTK_LASTUSER  '\x3F'

#endif /* _MATHLINK_H */

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

#define omlink_MLPutRealArray 		omlink_MLPutDoubleArray
#define omlink_MLGetRealArray    	omlink_MLGetDoubleArray
#define omlink_MLDisownRealArray 	omlink_MLDisownDoubleArray

#define omlink_MLGetReal 			omlink_MLGetDouble

///////////////////////////// Starting MathLink ////////////////////////////
///////////////////////////// Starting MathLink ////////////////////////////
///////////////////////////// Starting MathLink ////////////////////////////

/**#
 *MLDECL( MLEnvironment, MLInitialize,   ( MLParametersPointer p));  // pass in NULL
 */
OMLINK_API LPVOID omlink_MLInitialize(LPSTR lpMLParam);  // pass in NULL

/**#
 *MLDECL( void,          MLDeinitialize, ( MLEnvironment env));
 */
OMLINK_API void omlink_MLDeinitialize(LPVOID env);

/**#
 *MLDECL( MLINK,         MLOpenArgv,      ( MLEnvironment ep, charpp_ct argv, charpp_ct argv_end, longp_ct errp));
 */
OMLINK_API LPVOID omlink_MLOpenArgv(LPVOID ep, LPVOID argv, LPVOID argv_end, long *errp);

/**#
 *MLDECL( void,          MLClose,           ( MLINK mlp));
 */
OMLINK_API void omlink_MLClose(LPVOID mlp);

/**#
 *MLDECL( mlapi_result,  MLConnect,         ( MLINK mlp));
 */
OMLINK_API int omlink_MLConnect(LPVOID mlp);

/**#
 *MLDECL( kcharp_ct, MLName,    ( MLINK mlp));
 */
OMLINK_API LPCSTR omlink_MLName(LPVOID mlp);

/**#
 *MLDECL( long,      MLNumber,  ( MLINK mlp));
 */
OMLINK_API long omlink_MLNumber(LPVOID mlp);

/**#
 *MLDECL( charp_ct,  MLSetName, ( MLINK mlp, kcharp_ct name));
 */
OMLINK_API LPSTR omlink_MLSetName(LPVOID mlp, LPCSTR lpcszName);

/**#
 *MLDECL( kcharp_ct,     MLErrorMessage,  ( MLINK mlp));
 */
OMLINK_API LPCSTR omlink_MLErrorMessage(LPVOID mlp);

/**#
 *MLDECL( mlapi_result,   MLPutMessage,   ( MLINK mlp, dev_message  msg));
 */
OMLINK_API int omlink_MLPutMessage(LPVOID mlp, unsigned long msg);

/**#
 *MLDECL( mlapi_result,   MLMessageReady, ( MLINK mlp));
 */
OMLINK_API int omlink_MLMessageReady(LPVOID mlp);

/**#
 *MLDECL( mlapi_result,   MLGetMessage,   ( MLINK mlp, dev_messagep mp, dev_messagep np));
 */
OMLINK_API int omlink_MLGetMessage(LPVOID mlp, LPDWORD lpMsgm, LPDWORD lpMsgn);

/**#
 *MLDECL( mlapi_error,   MLError,        ( MLINK mlp));
 */
OMLINK_API long omlink_MLError(LPVOID mlp);

/**#
 *MLDECL( mlapi_result,  MLClearError,   ( MLINK mlp));
 */
OMLINK_API int omlink_MLClearError(LPVOID mlp);


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// Put function
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

/**#
 *MLDECL( mlapi_result,   MLPutBinaryNumber, ( MLINK mlp, voidp_ct np, long type));
 */
OMLINK_API int omlink_MLPutBinaryNumber(LPVOID mlp, LPVOID lpNumber, long type);

/**#
 *MLDECL( mlapi_result,   MLPutShortInteger, ( MLINK mlp, int_nt h));
 */
OMLINK_API int omlink_MLPutShortInteger(LPVOID mlp, int nVal);

/**#
 *MLDECL( mlapi_result,   MLPutInteger,      ( MLINK mlp, int_nt i));
 */
OMLINK_API int omlink_MLPutInteger(LPVOID mlp, int nVal);

/**#
 *MLDECL( mlapi_result,   MLPutLongInteger,  ( MLINK mlp, long_nt l));
 */
OMLINK_API int omlink_MLPutLongInteger(LPVOID mlp, long lVal);

/**#
 *MLDECL( mlapi_result,   MLPutFloat,        ( MLINK mlp, double_nt f));
 */
OMLINK_API int omlink_MLPutFloat(LPVOID mlp, double dVal);

/**#
 *MLDECL( mlapi_result,   MLPutDouble,       ( MLINK mlp, double_nt d));
 */
OMLINK_API int omlink_MLPutDouble(LPVOID mlp, double dVal);

/**#
 *MLDECL( mlapi_result,   MLPut16BitCharacters, ( MLINK mlp, long_st chars_left, kushortp_ct codes, long_st ncodes));
 */
OMLINK_API int omlink_MLPut16BitCharacters(LPVOID mlp, long chars_left, const WORD *lpcCodes, long ncodes);

/**#
 *MLDECL( mlapi_result,   MLPut8BitCharacters,  ( MLINK mlp, long_st chars_left, kucharp_ct bytes, long_st nbytes));
 */
OMLINK_API int omlink_MLPut8BitCharacters(LPVOID mlp, long chars_left, const LPBYTE lpcBytes, long nbytes);

/**#
 *MLDECL( mlapi_result,   MLPut7BitCount,       ( MLINK mlp, long_st count, long_st size));
 */
OMLINK_API int omlink_MLPut7BitCount(LPVOID mlp, long count, long size);

/**#
 *MLDECL( mlapi_result,   MLPut7BitCharacters,  ( MLINK mlp, long_st chars_left, kcharp_ct bytes, long_st nbytes, long_st nchars_now));
 */
OMLINK_API int omlink_MLPut7BitCharacters(LPVOID mlp, long chars_left, LPCSTR lpcBytes, long nbytes, long nchars_now);

/**#
 *MLDECL( mlapi_result,   MLPutUnicodeString, ( MLINK mlp, kushortp_ct s, long_st len));
 */
OMLINK_API int omlink_MLPutUnicodeString(LPVOID mlp, const WORD *lpcs, long len);

/**#
 *MLDECL( mlapi_result,   MLPutByteString,    ( MLINK mlp, kucharp_ct  s, long_st len));
 */
OMLINK_API int omlink_MLPutByteString(LPVOID mlp, const LPBYTE lpcs, long len);

/**#
 *MLDECL( mlapi_result,   MLPutString,        ( MLINK mlp, kcharp_ct   s));
 */
OMLINK_API int omlink_MLPutString(LPVOID mlp, LPCSTR lpstr);

/**#
 *MLDECL( mlapi_result,   MLPutUnicodeSymbol, ( MLINK mlp, kushortp_ct s, long_st len));
 */
OMLINK_API int omlink_MLPutUnicodeSymbol(LPVOID mlp, const WORD *lpcSymbol, long len);

/**#
 *MLDECL( mlapi_result,   MLPutByteSymbol,    ( MLINK mlp, kucharp_ct  s, long_st len));
 */
OMLINK_API int omlink_MLPutByteSymbol(LPVOID mlp, const LPBYTE lpcSymbol, long len);

/**#
 *MLDECL( mlapi_result,   MLPutSymbol,        ( MLINK mlp, kcharp_ct   s));
 */
OMLINK_API int omlink_MLPutSymbol(LPVOID mlp, LPCSTR lpcsz);

/**#
 *MLDECL( mlapi_result,   MLPutFunction,      ( MLINK mlp, kcharp_ct s, long_st argc));
 */
OMLINK_API int omlink_MLPutFunction(LPVOID mlp, LPCSTR lpcstr, long argc);

/**#
 *MLDECL( mlapi_result,   MLPutSize, ( MLINK mlp, long_st size));
 */
OMLINK_API int omlink_MLPutSize(LPVOID mlp, long size);

/**#
 *MLDECL( mlapi_result,   MLPutData, ( MLINK mlp, kcharp_ct buff, long_st len));
 */
OMLINK_API int omlink_MLPutData(LPVOID mlp, LPCSTR lpcBuff, long len);

/**#
 *MLDECL( mlapi_result,   MLPutArray,                 ( MLINK mlp, array_meterp meter));
 */
OMLINK_API int omlink_MLPutArray(LPVOID mlp, LPVOID lpmeter);

/**#
 *MLDECL( mlapi_result,   MLPutBinaryNumberArrayData, ( MLINK mlp, array_meterp meter, voidp_ct     datap, long_st count, long type));
 */
OMLINK_API int omlink_MLPutBinaryNumberArrayData(LPVOID mlp, LPVOID lpmeter, LPVOID lpdata, long count, long type);

/**#
 *MLDECL( mlapi_result,   MLPutByteArrayData,         ( MLINK mlp, array_meterp meter, ucharp_nt    datap, long_st count));
 */
OMLINK_API int omlink_MLPutByteArrayData(LPVOID mlp, LPVOID lpmeter, LPBYTE lpdata, long count);

/**#
 *MLDECL( mlapi_result,   MLPutShortIntegerArrayData, ( MLINK mlp, array_meterp meter, shortp_nt    datap, long_st count));
 */
OMLINK_API int omlink_MLPutShortIntegerArrayData(LPVOID mlp, LPVOID lpmeter, short *lpdata, long count);

/**#
 *MLDECL( mlapi_result,   MLPutIntegerArrayData,      ( MLINK mlp, array_meterp meter, intp_nt      datap, long_st count));
 */
OMLINK_API int omlink_MLPutIntegerArrayData(LPVOID mlp, LPVOID lpmeter, int *lpdata, long count);

/**#
 *MLDECL( mlapi_result,   MLPutLongIntegerArrayData,  ( MLINK mlp, array_meterp meter, longp_nt     datap, long_st count));
 */
OMLINK_API int omlink_MLPutLongIntegerArrayData(LPVOID mlp, LPVOID lpmeter, long *lpdata, long count);

/**#
 *MLDECL( mlapi_result,   MLPutFloatArrayData,        ( MLINK mlp, array_meterp meter, floatp_nt    datap, long_st count));
 */
OMLINK_API int omlink_MLPutFloatArrayData(LPVOID mlp, LPVOID lpmeter, float *lpdata, long count);

/**#
 *MLDECL( mlapi_result,   MLPutDoubleArrayData,       ( MLINK mlp, array_meterp meter, doublep_nt   datap, long_st count));
 */
OMLINK_API int omlink_MLPutDoubleArrayData(LPVOID mlp, LPVOID lpmeter, double *lpdata, long count);

/**#
 *MLDECL( mlapi_result,   MLPutBinaryNumberArray, ( MLINK mlp, voidp_ct     data, longp_st dims, charpp_ct heads, long_st depth, long type));
 */
OMLINK_API int omlink_MLPutBinaryNumberArray(LPVOID mlp, LPVOID lpdata, long *lpdims, LPVOID lpheads, long depth, long type);

/**#
 *MLDECL( mlapi_result,   MLPutByteArray,         ( MLINK mlp, ucharp_nt    data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API int omlink_MLPutByteArray(LPVOID mlp, LPBYTE lpdata, long *lpdims, LPVOID lpheads, long depth);

/**#
 *MLDECL( mlapi_result,   MLPutShortIntegerArray, ( MLINK mlp, shortp_nt    data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API int omlink_MLPutShortIntegerArray(LPVOID mlp, short *lpdata, long *lpdims, LPVOID lpheads, long depth);

/**#
 *MLDECL( mlapi_result,   MLPutIntegerArray,      ( MLINK mlp, intp_nt      data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API int omlink_MLPutIntegerArray(LPVOID mlp, int *lpdata, long *lpdims, LPVOID lpheads, long depth);

/**#
 *MLDECL( mlapi_result,   MLPutLongIntegerArray,  ( MLINK mlp, longp_nt     data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API int omlink_MLPutLongIntegerArray(LPVOID mlp, long *lpdata, long *lpdims, LPVOID lpheads, long depth);

/**#
 *MLDECL( mlapi_result,   MLPutDoubleArray,       ( MLINK mlp, doublep_nt   data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API int omlink_MLPutDoubleArray(LPVOID mlp, double *lpdata, long *lpdims, LPVOID lpheads, long depth);

/**#
 *MLDECL( mlapi_result,   MLPutFloatArray,        ( MLINK mlp, floatp_nt    data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API int omlink_MLPutFloatArray(LPVOID mlp, float *lpdata, long *lpdims, LPVOID lpheads, long depth);

/**#
 *MLDECL( mlapi_result,   MLPutBinaryNumberList, ( MLINK mlp, voidp_ct   data, long_st count, long type));
 */
OMLINK_API int omlink_MLPutBinaryNumberList(LPVOID mlp, LPVOID lpdata, long count, long type);

/**#
 *MLDECL( mlapi_result,   MLPutIntegerList,      ( MLINK mlp, intp_nt    data, long_st count));
 */
OMLINK_API int omlink_MLPutIntegerList(LPVOID mlp, int *lpiData, long count);

/**#
 *MLDECL( mlapi_result,   MLPutRealList,         ( MLINK mlp, doublep_nt data, long_st count));
 */
OMLINK_API int omlink_MLPutRealList(LPVOID mlp, double *pdData, long count);

/**#
 *MLDECL( mlapi_result,   MLPutNext,      ( MLINK mlp, mlapi_token tok));
 */
OMLINK_API int omlink_MLPutNext(LPVOID mlp, int nToken);

/**#
 *MLDECL( mlapi_result,   MLPutType,      ( MLINK mlp, mlapi__token tok));
 */
OMLINK_API int omlink_MLPutType(LPVOID mlp, long nToken);

/**#
 *MLDECL( mlapi_result,   MLPutRawSize,   ( MLINK mlp, long_st size));
 */
OMLINK_API int omlink_MLPutRawSize(LPVOID mlp, long size);

/**#
 *MLDECL( mlapi_result,   MLPutRawData,   ( MLINK mlp, kucharp_ct data, long_st len));
 */
OMLINK_API int omlink_MLPutRawData(LPVOID mlp, const LPBYTE lpcData, long len);

/**#
 *MLDECL( mlapi_result,   MLPutArgCount,  ( MLINK mlp, long_st argc));
 */
OMLINK_API int omlink_MLPutArgCount(LPVOID mlp, long argc);

/**#
 *MLDECL( mlapi_result,   MLPutComposite, ( MLINK mlp, long_st argc));
 */
OMLINK_API int omlink_MLPutComposite(LPVOID mlp, long argc);

/**#
 *MLDECL( mlapi_result,   MLBytesToPut,   ( MLINK mlp, longp_st leftp));
 */
OMLINK_API int omlink_MLBytesToPut(LPVOID mlp, long *lpLeft);

/**#
 *MLDECL( mlapi_result,   MLEndPacket,    ( MLINK mlp));
 */
OMLINK_API int omlink_MLEndPacket(LPVOID mlp);

/**#
 *MLDECL( mlapi_result,   MLFlush,        ( MLINK mlp));
 */
OMLINK_API int omlink_MLFlush(LPVOID mlp);

/**#
 *MLDECL( mlapi_packet,  MLNextPacket, ( MLINK mlp));
 */
OMLINK_API int omlink_MLNextPacket(LPVOID mlp);


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// Gut function
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

/**#
 *MLDECL( mlapi_result,   MLGetBinaryNumber, ( MLINK mlp, voidp_ct np, long type));
 */
OMLINK_API int omlink_MLGetBinaryNumber(LPVOID mlp, LPVOID lpData, long type);

/**#
 *MLDECL( mlapi_result,   MLGetShortInteger, ( MLINK mlp, shortp_nt hp));
 */
OMLINK_API int omlink_MLGetShortInteger(LPVOID mlp, short *pShort);

/**#
 *MLDECL( mlapi_result,   MLGetInteger,      ( MLINK mlp, intp_nt ip));
 */
OMLINK_API int omlink_MLGetInteger(LPVOID mlp, int *lpInt);


/**#
 *MLDECL( mlapi_result,   MLGetLongInteger,  ( MLINK mlp, longp_nt lp));
 */
OMLINK_API int omlink_MLGetLongInteger(LPVOID mlp, long *lpLong);

/**#
 *MLDECL( mlapi_result,   MLGetFloat,        ( MLINK mlp, floatp_nt fp));
 */
OMLINK_API int omlink_MLGetFloat(LPVOID mlp, float *pFloat);

/**#
 *MLDECL( mlapi_result,   MLGetDouble,       ( MLINK mlp, doublep_nt dp));
 */
OMLINK_API int omlink_MLGetDouble(LPVOID mlp, double *pDouble);

/**#
 *MLDECL( mlapi_result,   MLGet16BitCharacters,  ( MLINK mlp, longp_st chars_left, ushortp_ct buf, long_st cardof_buf, longp_st got));
 */
OMLINK_API int omlink_MLGet16BitCharacters(LPVOID mlp, long *pChars_left, USHORT *pBuf, long cardof_buf, long *lpGot);

/**#
 *MLDECL( mlapi_result,   MLGet8BitCharacters,   ( MLINK mlp, longp_st chars_left, ucharp_ct  buf, long_st cardof_buf, longp_st got, long missing));
 */
OMLINK_API int omlink_MLGet8BitCharacters(LPVOID mlp, long *lpChars_left, LPBYTE lpBuf, long cardof_buf, long *lpGot, long missing);

/**#
 *MLDECL( mlapi_result,   MLGet7BitCharacters,   ( MLINK mlp, longp_st chars_left, charp_ct   buf, long_st cardof_buf, longp_st got));
 */
OMLINK_API int omlink_MLGet7BitCharacters(LPVOID mlp, long *lpChars_left, LPSTR lpBuf, long cardof_buf, long *lpGot);

/**#
 *MLDECL( mlapi_result,   MLGetUnicodeString,    ( MLINK mlp, kushortpp_ct sp, longp_st lenp));
 */
OMLINK_API int omlink_MLGetUnicodeString(LPVOID mlp, LPVOID lpsp, long *lpLen);

/**#
 *MLDECL( mlapi_result,   MLGetByteString,       ( MLINK mlp, kucharpp_ct  sp, longp_st lenp, long missing));
 */
OMLINK_API int omlink_MLGetByteString(LPVOID mlp, const LPVOID lpsp, long *lplen, long missing);

/**#
 *MLDECL( mlapi_result,   MLGetString,           ( MLINK mlp, kcharpp_ct   sp));
 */
OMLINK_API int omlink_MLGetString(LPVOID mlp, const LPVOID lpsp);

/**#
 *MLDECL( mlapi_result,   MLGetUnicodeSymbol,    ( MLINK mlp, kushortpp_ct sp, longp_st lenp));
 */
OMLINK_API int omlink_MLGetUnicodeSymbol(LPVOID mlp, const LPVOID lpsp, long *lpLen);

/**#
 *MLDECL( mlapi_result,   MLGetByteSymbol,       ( MLINK mlp, kucharpp_ct  sp, longp_st lenp, long missing));
 */
OMLINK_API int omlink_MLGetByteSymbol(LPVOID mlp, const LPVOID lpsp, long *lpLen, long missing);

/**#
 *MLDECL( mlapi_result,   MLGetSymbol,           ( MLINK mlp, kcharpp_ct   sp));
 */
OMLINK_API int omlink_MLGetSymbol(LPVOID mlp, const LPVOID lpsp);

/**#
 *MLDECL( void,           MLDisownUnicodeString, ( MLINK mlp, kushortp_ct s,   long_st len));
 */
OMLINK_API void omlink_MLDisownUnicodeString(LPVOID mlp, const WORD *lpcs, long len);

/**#
 *MLDECL( void,           MLDisownByteString,    ( MLINK mlp, kucharp_ct  s,   long_st len));
 */
OMLINK_API void omlink_MLDisownByteString(LPVOID mlp, const LPBYTE lpcs, long len);

/**#
 *MLDECL( void,           MLDisownString,        ( MLINK mlp, kcharp_ct   s));
 */
OMLINK_API void omlink_MLDisownString(LPVOID mlp, LPCSTR lpcs);

/**#
 *MLDECL( void,           MLDisownUnicodeSymbol, ( MLINK mlp, kushortp_ct s,   long_st len));
 */
OMLINK_API void omlink_MLDisownUnicodeSymbol(LPVOID mlp, const WORD *lpcs, long len);

/**#
 *MLDECL( void,           MLDisownByteSymbol,    ( MLINK mlp, kucharp_ct  s,   long_st len));
 */
OMLINK_API void omlink_MLDisownByteSymbol(LPVOID mlp, const LPBYTE lpcs, long len);

/**#
 *MLDECL( void,           MLDisownSymbol,        ( MLINK mlp, kcharp_ct   s));
 */
OMLINK_API void omlink_MLDisownSymbol(LPVOID mlp, LPCSTR lpcs);

/**#
 *MLDECL( mlapi_result,   MLCheckString,   ( MLINK mlp, kcharp_ct name));
 */
OMLINK_API int omlink_MLCheckString(LPVOID mlp, LPCSTR lpName);

/**#
 *MLDECL( mlapi_result,   MLCheckSymbol,   ( MLINK mlp, kcharp_ct name));
 */
OMLINK_API int omlink_MLCheckSymbol(LPVOID mlp, LPCSTR lpName);

/**#
 *MLDECL( mlapi_result,   MLGetFunction,   ( MLINK mlp, kcharpp_ct sp, longp_st countp));
 */
OMLINK_API int omlink_MLGetFunction(LPVOID mlp, const LPVOID lpsp, long *lpCount);

/**#
 *MLDECL( mlapi_result,   MLCheckFunction, ( MLINK mlp, kcharp_ct s, longp_st countp));
 */
OMLINK_API int omlink_MLCheckFunction(LPVOID mlp, LPCSTR lpcs, long *lpCount);

/**#
 *MLDECL( mlapi_result,   MLCheckFunctionWithArgCount, ( MLINK mlp, kcharp_ct s, longp_st countp));
 */
OMLINK_API int omlink_MLCheckFunctionWithArgCount(LPVOID mlp, LPCSTR lpcs, long *lpCount);

/**#
 *MLDECL( mlapi_token,    MLGetNext,          ( MLINK mlp));
 */
OMLINK_API int omlink_MLGetNext(LPVOID mlp);

/**#
 *MLDECL( mlapi_token,    MLGetNextRaw,       ( MLINK mlp));
 */
OMLINK_API int omlink_MLGetNextRaw(LPVOID mlp);

/**#
 *MLDECL( mlapi_token,    MLGetType,          ( MLINK mlp));
 */
OMLINK_API int omlink_MLGetType(LPVOID mlp);

/**#
 *MLDECL( mlapi_token,    MLGetRawType,       ( MLINK mlp));
 */
OMLINK_API int omlink_MLGetRawType(LPVOID mlp);

/**#
 *MLDECL( mlapi_result,   MLGetRawData,       ( MLINK mlp, ucharp_ct data, long_st size, longp_st gotp));
 */
OMLINK_API int omlink_MLGetRawData(LPVOID mlp, LPBYTE lpData, long size, long *lpGot);

/**#
 *MLDECL( mlapi_result,   MLGetData,          ( MLINK mlp, charp_ct data, long_st size, longp_st gotp));
 */
OMLINK_API int omlink_MLGetData(LPVOID mlp, LPSTR lpData, long size, long *lpGot);

/**#
 *MLDECL( mlapi_result,   MLGetArgCount,      ( MLINK mlp, longp_st countp));
 */
OMLINK_API int omlink_MLGetArgCount(LPVOID mlp, long *lpCount);

/**#
 *MLDECL( mlapi_result,   MLGetRawArgCount,   ( MLINK mlp, longp_st countp));
 */
OMLINK_API int omlink_MLGetRawArgCount(LPVOID mlp, long *lpCount);

/**#
 *MLDECL( mlapi_result,   MLBytesToGet,       ( MLINK mlp, longp_st leftp));
 */
OMLINK_API int omlink_MLBytesToGet(LPVOID mlp, long *lpLeft);

/**#
 *MLDECL( mlapi_result,   MLRawBytesToGet,    ( MLINK mlp, longp_st leftp));
 */
OMLINK_API int omlink_MLRawBytesToGet(LPVOID mlp, long *lpLeft);

/**#
 *MLDECL( mlapi_result,   MLExpressionsToGet, ( MLINK mlp, longp_st countp));
 */
OMLINK_API int omlink_MLExpressionsToGet(LPVOID mlp, long *lpCount);

/**#
 *MLDECL( mlapi_result,   MLNewPacket,        ( MLINK mlp));
 */
OMLINK_API int omlink_MLNewPacket(LPVOID mlp);

/**#
 *MLDECL( mlapi_result,   MLTakeLast,         ( MLINK mlp, long_st eleft));
 */
OMLINK_API int omlink_MLTakeLast(LPVOID mlp, long lLeft);

/**#
 *MLDECL( mlapi_result,   MLReady,            ( MLINK mlp));
 */
OMLINK_API int omlink_MLReady(LPVOID mlp);

/**#
 *MLDECL( mlapi_result,   MLFill,             ( MLINK mlp));
 */
OMLINK_API int omlink_MLFill(LPVOID mlp);


/**#
 *MLDECL( mlapi_result,  MLGetBinaryNumberList, ( MLINK mlp, voidpp_ct   datap, longp_st countp, long type));
 */
OMLINK_API int omlink_MLGetBinaryNumberList(LPVOID mlp, LPVOID *lpData, long *lpCount, long type);

/**#
 *MLDECL( mlapi_result,  MLGetIntegerList,      ( MLINK mlp, intpp_nt    datap, longp_st countp));
 */
OMLINK_API int omlink_MLGetIntegerList(LPVOID mlp, int **lpData, long *lpCount);

/**#
 *MLDECL( mlapi_result,  MLGetRealList,         ( MLINK mlp, doublepp_nt datap, longp_st countp));
 */
OMLINK_API int omlink_MLGetRealList(LPVOID mlp, double **pData, long *lpCount);

/**#
 *MLDECL( void, MLDisownBinaryNumberList, ( MLINK mlp, voidp_ct   data, long_st count, long type));
 */
OMLINK_API void omlink_MLDisownBinaryNumberList(LPVOID mlp, LPVOID lpData, long count, long type);

/**#
 *MLDECL( void, MLDisownIntegerList,      ( MLINK mlp, intp_nt    data, long_st count));
 */
OMLINK_API void omlink_MLDisownIntegerList(LPVOID mlp, int *lpData, long count);

/**#
 *MLDECL( void, MLDisownRealList,         ( MLINK mlp, doublep_nt data, long_st count));
 */
OMLINK_API void omlink_MLDisownRealList(LPVOID mlp, double *pData, long count);

/**#
 *MLDECL( mlapi_token,    MLGetArrayType,             ( MLINK mlp, array_meterp meter));
 */
OMLINK_API int omlink_MLGetArrayType(LPVOID mlp, LPVOID lpmeter);

/**#
 *MLDECL( mlapi_result,   MLGetArrayDimensions,       ( MLINK mlp, array_meterp meter));
 */
OMLINK_API int omlink_MLGetArrayDimensions(LPVOID mlp, LPVOID lpmeter);

/**#
 *MLDECL( mlapi_result,   MLGetBinaryNumberArrayData, ( MLINK mlp, array_meterp meter, voidp_ct     datap, long_st count, long type));
 */
OMLINK_API int omlink_MLGetBinaryNumberArrayData(LPVOID mlp, LPVOID lpmeter, LPVOID lpData, long count, long type);

/**#
 *MLDECL( mlapi_result,   MLGetByteArrayData,         ( MLINK mlp, array_meterp meter, ucharp_nt    datap, long_st count));
 */
OMLINK_API int omlink_MLGetByteArrayData(LPVOID mlp, LPVOID lpmeter, LPBYTE lpData, long count);

/**#
 *MLDECL( mlapi_result,   MLGetShortIntegerArrayData, ( MLINK mlp, array_meterp meter, shortp_nt    datap, long_st count));
 */
OMLINK_API int omlink_MLGetShortIntegerArrayData(LPVOID mlp, LPVOID lpmeter, short *pData, long count);

/**#
 *MLDECL( mlapi_result,   MLGetIntegerArrayData,      ( MLINK mlp, array_meterp meter, intp_nt      datap, long_st count));
 */
OMLINK_API int omlink_MLGetIntegerArrayData(LPVOID mlp, LPVOID lpmeter, int *lpData, long count);

/**#
 *MLDECL( mlapi_result,   MLGetLongIntegerArrayData,  ( MLINK mlp, array_meterp meter, longp_nt     datap, long_st count));
 */
OMLINK_API int omlink_MLGetLongIntegerArrayData(LPVOID mlp, LPVOID lpmeter, long *lpData, long count);

/**#
 *MLDECL( mlapi_result,   MLGetFloatArrayData,        ( MLINK mlp, array_meterp meter, floatp_nt    datap, long_st count));
 */
OMLINK_API int omlink_MLGetFloatArrayData(LPVOID mlp, LPVOID lpmeter, float *pData, long count);

/**#
 *MLDECL( mlapi_result,   MLGetDoubleArrayData,       ( MLINK mlp, array_meterp meter, doublep_nt   datap, long_st count));
 */
OMLINK_API int omlink_MLGetDoubleArrayData(LPVOID mlp, LPVOID lpmeter, double *pData, long count);

/**#
 *MLDECL( mlapi_result,   MLGetBinaryNumberArray,    ( MLINK mlp, voidpp_ct     datap, longpp_st dimpp, charppp_ct headsp, longp_st depthp, long type));
 */
OMLINK_API int omlink_MLGetBinaryNumberArray(LPVOID mlp, LPVOID *lpData, long **lpdim, LPVOID lpHead, long *lpDepth, long type);

/**#
 *MLDECL( mlapi_result,   MLGetByteArray,            ( MLINK mlp, ucharpp_nt    datap, longpp_st dimsp, charppp_ct headsp, longp_st depthp));
 */
OMLINK_API int omlink_MLGetByteArray(LPVOID mlp, LPBYTE *lpData, long **lpdim, LPVOID lpHead, long *lpDepth);

/**#
 *MLDECL( mlapi_result,   MLGetShortIntegerArray,    ( MLINK mlp, shortpp_nt    datap, longpp_st dimsp, charppp_ct headsp, longp_st depthp));
 */
OMLINK_API int omlink_MLGetShortIntegerArray(LPVOID mlp, short **pData, long **lpdim, LPVOID lpHead, long *lpDepth);

/**#
 *MLDECL( mlapi_result,   MLGetIntegerArray,         ( MLINK mlp, intpp_nt      datap, longpp_st dimsp, charppp_ct headsp, longp_st depthp));
 */
OMLINK_API int omlink_MLGetIntegerArray(LPVOID mlp, int **lpData, long **lpdim, LPVOID lpHead, long *lpDepth);

/**#
 *MLDECL( mlapi_result,   MLGetLongIntegerArray,     ( MLINK mlp, longpp_nt     datap, longpp_st dimsp, charppp_ct headsp, longp_st depthp));
 */
OMLINK_API int omlink_MLGetLongIntegerArray(LPVOID mlp, long **lpData, long **lpdim, LPVOID lpHead, long *lpDepth);

/**#
 *MLDECL( mlapi_result,   MLGetDoubleArray,          ( MLINK mlp, doublepp_nt   datap, longpp_st dimsp, charppp_ct headsp, longp_st depthp));
 */
OMLINK_API int omlink_MLGetDoubleArray(LPVOID mlp, double **pData, long **lpdim, LPVOID lpHead, long *lpDepth);

/**#
 *MLDECL( mlapi_result,   MLGetFloatArray,           ( MLINK mlp, floatpp_nt    datap, longpp_st dimsp, charppp_ct headsp, longp_st depthp));
 */
OMLINK_API int omlink_MLGetFloatArray(LPVOID mlp, float **pData, long **lpdim, LPVOID lpHead, long *lpDepth);

/**#
 *MLDECL( void,           MLDisownBinaryNumberArray, ( MLINK mlp, voidp_ct     data, longp_st dimp, charpp_ct heads, long_st len, long type));
 */
OMLINK_API void omlink_MLDisownBinaryNumberArray(LPVOID mlp, LPVOID lpData, long *lpdim, LPVOID lpHead, long len, long type);

/**#
 *MLDECL( void,           MLDisownByteArray,         ( MLINK mlp, ucharp_nt    data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API void omlink_MLDisownByteArray(LPVOID mlp, LPBYTE lpData, long *lpdim, LPVOID lpHead, long depth);

/**#
 *MLDECL( void,           MLDisownShortIntegerArray, ( MLINK mlp, shortp_nt    data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API void omlink_MLDisownShortIntegerArray(LPVOID mlp, short *pData, long *lpdim, LPVOID lpHead, long depth);

/**#
 *MLDECL( void,           MLDisownIntegerArray,      ( MLINK mlp, intp_nt      data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API void omlink_MLDisownIntegerArray(LPVOID mlp, int *lpData, long *lpdim, LPVOID lpHead, long depth);

/**#
 *MLDECL( void,           MLDisownLongIntegerArray,  ( MLINK mlp, longp_nt     data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API void omlink_MLDisownLongIntegerArray(LPVOID mlp, long *lpData, long *lpdim, LPVOID lpHead, long depth);

/**#
 *MLDECL( void,           MLDisownFloatArray,        ( MLINK mlp, floatp_nt    data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API void omlink_MLDisownFloatArray(LPVOID mlp, float *pData, long *lpdim, LPVOID lpHead, long depth);

/**#
 *MLDECL( void,           MLDisownDoubleArray,       ( MLINK mlp, doublep_nt   data, longp_st dims, charpp_ct heads, long_st depth));
 */
OMLINK_API void omlink_MLDisownDoubleArray(LPVOID mlp, double *pData, long *lpdim, LPVOID lpHead, long depth);

#ifdef TEST_OC_USING_VC
/**#
 */
OMLINK_API int omlink_init_and_openlink(LPCSTR lpcszMMPath);
#endif //TEST_OC_USING_VC

#ifdef __AFX_H__
	}
#endif	 //__AFX_H__

#endif  //_OMLINK_H
